'*************************************************************
' 
' ADOBE SYSTEMS INCORPORATED 
' Copyright 2005-2010 Adobe Systems Incorporated 
' All Rights Reserved 

' NOTICE:  Adobe permits you to use, modify, and 
' distribute this file in accordance with the terms
' of the Adobe license agreement accompanying it.  
' If you have received this file from a source 
' other than Adobe, then your use, modification,
' or distribution of it requires the prior 
' written permission of Adobe. 
' 
'*************************************************************

' ContactSheet.vbs

' DESCRIPTION

' This sample iterates through all images in a folder and 
' creates a named thumb nail for each of these images. The 
' number of rows and columns are hard-coded as the InputBox 
' VBScript function cannot be called within Illustrator.
' 
'*************************************************************

' Main Code - execution begins here

' Create the Application object and get a set of image files to work with
Set appRef = CreateObject("Illustrator.Application")
Set fileSystemObject = CreateObject("Scripting.FileSystemObject")

' Creating a folder browser in VBScript can be a problem (relying on either Windows API calls
' or use of ActiveX controls which may not be present on a given system). Instead, use
' Illustrator's built-in JavaScript to display a file browser. DoJavaScript can return a value,
' in this example it's the platform specific full path to the chosen folder.

doJavaScript = "var imagesFolder = Folder.selectDialog(""Select images folder:""); if (imagesFolder) folderPath = imagesFolder.fsName;"
imagesFolderPath = appRef.DoJavaScript(doJavaScript)

If (fileSystemObject.FolderExists(imagesFolderPath)) Then

	doJavaScript = "var numRows = prompt(""Enter number of rows:"", ""4""); if (numRows) numRows = parseInt(numRows); else numRows = 0;"
	numRows = appRef.DoJavaScript(doJavaScript)

	doJavaScript = "var numCols = prompt(""Enter number of columns:"", ""4""); if (numCols) numCols = parseInt(numCols); else numCols = 0;"
	numCols = appRef.DoJavaScript(doJavaScript)
	
	If (numRows > 0 And numCols > 0) Then
		imagesFolderPathTemp = Replace( imagesFolderPath, "\", "\\")
		doJavaScript = "alert(""Path to the test files used: " & CStr(imagesFolderPathTemp) & "    Number of rows: " & numRows & "  Number of columns: " & numCols & "  "")"
		appRef.DoJavaScript doJavaScript

		' Call function DoIt to iterate through all images in the folder 
		' and create the contact sheet
		Call DoIt(imagesFolderPath, CStr(numRows), CStr(numCols), 24, 22)
	Else
		doJavaScript = "alert(""Script requires at least 1 row and 1 column!"");"
		appRef.DoJavaScript doJavaScript
	End If

End If
'*************************************************************

' This routine iterates through all images in the folder and creates a named
' thumb nail for each of these

Sub DoIt(sDirName, verticalCount, horizontalCount, horizontalSpacing, verticalSpacing)
          
        ' Get the test files from the folder sDirName
        Set fso = CreateObject("Scripting.FileSystemObject")
	Set fldr = fso.GetFolder(sDirName)
	Set fls = fldr.Files
        numImages = verticalCount * horizontalCount
        Dim numFiles
        numFiles = fls.count
        Dim fileNames(5)
        
	
	' Add a new document
	Set docRef = appRef.Documents.Add
        
        ' Determine the dimensions of the document
        docPageOrigin = docRef.PageOrigin
        docLeft = docPageOrigin(0)
  	docTop = docRef.Height - docPageOrigin(1)
        printableWidth = docRef.Width - docLeft * 2
        printableHeight = docRef.Height - docPageOrigin(1) * 2
        
        ' Calculate the size of the individual grid spaces that the images will be placed in
        ' Dim gridWidth, gridHeight As Double
       
        gridWidth = (printableWidth + horizontalSpacing) / horizontalCount
        gridHeight = (printableHeight + verticalSpacing) / verticalCount
        
        ' Calculate the size of the individual images based on the printable document area,
        ' and on the number of images to be placed across and down the page
       
        imageWidth = gridWidth - horizontalSpacing
        imageHeight = gridHeight - verticalSpacing
           
        ' Normalize the image size so we end up with a square image
        
        If imageWidth < imageHeight Then
        	imageSize = imageWidth
                xAdjustment = 0
                yAdjustment = (imageHeight - imageWidth) / 2
        Else
                imageSize = imageHeight
                xAdjustment = (imageWidth - imageHeight) / 2
                yAdjustment = 0
        End If
            
        ' Calculate the bounding box for the first image to be placed
        ' Dim imageLeft, imageRight, imageTop, imageBottom As Double
        imageLeft = docLeft + xAdjustment
        imageRight = imageLeft + imageSize
            
        imageTop = docTop - yAdjustment
        imageBottom = imageTop - imageSize
            
        ' Iterate over the images in the list, positioning then one at a time
        ' After they are positioned, place a border around then to make them stand out better
        
        i = 1
        num = 0
        Dim aFile
        For each aFile in fls
		' Ignore system files.
		If not aFile.attributes and 4 Then
			num = num + 1
            		fileNames(num) = CStr(aFile)
		End If
        Next
        For j = 1 to numImages
        	
                Call AddRasterItemToPage(docRef,  fileNames(i), imageLeft, imageTop, (imageSize))
                    
                Call MakeFramingRectangle(docRef, imageLeft, imageTop, imageRight, imageBottom)
                Set fileObject = fso.getFile(fileNames(i))
                
                Call MakeTextLabel(docRef, CStr(fileObject.Name), imageLeft + imageSize / 2, imageBottom - 2)
                
                ' Calculate a new image position for the next iteration of the loop
                If j Mod horizontalCount <> 0 Then
                    ' Not at the end of row yet, move to next position in the row
                    imageLeft = imageLeft + gridWidth
                    imageRight = imageRight + gridWidth
                Else
                    ' If at the end of a row, first check to see if we have run out of rows
                    If j / horizontalCount >= verticalCount Then
                        Exit For
                    End If
                    
                    imageLeft = docLeft + xAdjustment
                    imageRight = imageLeft + imageSize
                        
                    imageTop = imageTop - gridHeight
                    imageBottom = imageBottom - gridHeight
                End If
                if (i = num) then
                    i = 1
                else
                    i = i + 1
                end if
        Next
            
        Set docRef = Nothing
        Set appRef = Nothing
End Sub

'*************************************************************

' This routine makes the labels for the thumbnails

Sub MakeTextLabel(aDocument, theText, xCenter, yVertPos)
                          
        ' Create the new text label
        Set aTextItem = aDocument.TextFrames.Add
        aTextItem.Contents = theText
        
        ' Calculate the final position and move the text label there
        aTextItem.Position = Array(xCenter - (aTextItem.Width / 2), yVertPos)
        
        ' Set the color of the text to default Illustrator color:
        ' No stroke & blank fill
        Set blackCMYK = CreateObject("Illustrator.CMYKColor")
        blackCMYK.Black = 100
        blackCMYK.Cyan = 0
        blackCMYK.Magenta = 0
        blackCMYK.Yellow = 0
        
        Set aTextRange = aTextItem.TextRange
        Set noStroke = CreateObject("Illustrator.NoColor")
        aTextRange.CharacterAttributes.StrokeColor = noStroke
        aTextRange.CharacterAttributes.FillColor = blackCMYK

End Sub

'*************************************************************

' This routine adds all images in the folder as RasterItems 
' to the Document

Sub AddRasterItemToPage(aDocument, theFile, imageLeft, imageTop, imageSize)
        
        ' Create a new raster item and link it to the image file
        Set aPlacedItem = aDocument.PlacedItems.Add
   	aPlacedItem.File = theFile
        
        ' Get the raster item dimensions
        itemWidth = aPlacedItem.Width
        itemHeight = aPlacedItem.Height
        
        ' Calculate the scale factors so the raster item can be fitted to the grid
        X_ScaleFactor = (imageSize / itemWidth) * 100
        Y_ScaleFactor = (imageSize / itemHeight) * 100
        
        ' Determine which of the scale factors to use
        If X_ScaleFactor < Y_ScaleFactor Then
            scaleFactor = X_ScaleFactor
        Else
            scaleFactor = Y_ScaleFactor
        End If
        
        ' Actually resize the raster item
        Call aPlacedItem.Resize(scaleFactor, scaleFactor)
                
        ' Get the new raster item dimensions
        itemWidth = aPlacedItem.Width
        itemHeight = aPlacedItem.Height
        
        ' Move the raster item to the middle of its grid cell
        aPlacedItem.Position = Array(imageLeft + (imageSize - itemWidth) / 2, _
                                     imageTop - (imageSize - itemHeight) / 2)
        
        Exit Sub

End Sub

'*************************************************************

Sub MakeFramingRectangle(aDocument, left, top, right, bottom)
        
        ' Add but not show the rectangle yet
       
        Set myPath = aDocument.PathItems.Rectangle(top, left, right - left, top - bottom)
        myPath.Hidden = True
        
        ' Make a black color
        Set blackCMYK = CreateObject("Illustrator.CMYKColor")
        
        blackCMYK.Black = 100
        blackCMYK.Cyan = 0
        blackCMYK.Magenta = 0
        blackCMYK.Yellow = 0
        
        ' Set the Color to 100% black
        myPath.StrokeColor = blackCMYK
        
        ' Make sure it is not filled
        myPath.Filled = False
        
        ' Show the resulting path
        myPath.Hidden = False
End Sub

'*************************************************************

'' SIG '' Begin signature block
'' SIG '' MIIY1QYJKoZIhvcNAQcCoIIYxjCCGMICAQExCzAJBgUr
'' SIG '' DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
'' SIG '' gjcCAR4wJAIBAQQQTvApFpkntU2P5azhDxfrqwIBAAIB
'' SIG '' AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFHAor4OrQCzw
'' SIG '' Lk7+i/OlMnNH5JenoIITuzCCA+4wggNXoAMCAQICEH6T
'' SIG '' 6/t8xk5Z6kuad9QG/DswDQYJKoZIhvcNAQEFBQAwgYsx
'' SIG '' CzAJBgNVBAYTAlpBMRUwEwYDVQQIEwxXZXN0ZXJuIENh
'' SIG '' cGUxFDASBgNVBAcTC0R1cmJhbnZpbGxlMQ8wDQYDVQQK
'' SIG '' EwZUaGF3dGUxHTAbBgNVBAsTFFRoYXd0ZSBDZXJ0aWZp
'' SIG '' Y2F0aW9uMR8wHQYDVQQDExZUaGF3dGUgVGltZXN0YW1w
'' SIG '' aW5nIENBMB4XDTEyMTIyMTAwMDAwMFoXDTIwMTIzMDIz
'' SIG '' NTk1OVowXjELMAkGA1UEBhMCVVMxHTAbBgNVBAoTFFN5
'' SIG '' bWFudGVjIENvcnBvcmF0aW9uMTAwLgYDVQQDEydTeW1h
'' SIG '' bnRlYyBUaW1lIFN0YW1waW5nIFNlcnZpY2VzIENBIC0g
'' SIG '' RzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIB
'' SIG '' AQCxrLNJVEuXHBIK2CV5kSJXKm/cuCbEQ3Nrwr8uUFr7
'' SIG '' FMJ2jkMBJUO0oeJF9Oi3e8N0zCLXtJQAAvdN7b+0t0Qk
'' SIG '' a81fRTvRRM5DEnMXgotptCvLmR6schsmTXEfsTHd+1Fh
'' SIG '' AlOmqvVJLAV4RaUvic7nmef+jOJXPz3GktxK+Hsz5HkK
'' SIG '' +/B1iEGc/8UDUZmq12yfk2mHZSmDhcJgFMTIyTsU2sCB
'' SIG '' 8B8NdN6SIqvK9/t0fCfm90obf6fDni2uiuqm5qonFn1h
'' SIG '' 95hxEbziUKFL5V365Q6nLJ+qZSDT2JboyHylTkhE/xni
'' SIG '' RAeSC9dohIBdanhkRc1gRn5UwRN8xXnxycFxAgMBAAGj
'' SIG '' gfowgfcwHQYDVR0OBBYEFF+a9W5czMx0mtTdfe8/2+xM
'' SIG '' gC7dMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAYYW
'' SIG '' aHR0cDovL29jc3AudGhhd3RlLmNvbTASBgNVHRMBAf8E
'' SIG '' CDAGAQH/AgEAMD8GA1UdHwQ4MDYwNKAyoDCGLmh0dHA6
'' SIG '' Ly9jcmwudGhhd3RlLmNvbS9UaGF3dGVUaW1lc3RhbXBp
'' SIG '' bmdDQS5jcmwwEwYDVR0lBAwwCgYIKwYBBQUHAwgwDgYD
'' SIG '' VR0PAQH/BAQDAgEGMCgGA1UdEQQhMB+kHTAbMRkwFwYD
'' SIG '' VQQDExBUaW1lU3RhbXAtMjA0OC0xMA0GCSqGSIb3DQEB
'' SIG '' BQUAA4GBAAMJm495739ZMKrvaLX64wkdu0+CBl03X6ZS
'' SIG '' nxaN6hySCURu9W3rWHww6PlpjSNzCxJvR6muORH4KrGb
'' SIG '' sBrDjutZlgCtzgxNstAxpghcKnr84nodV0yoZRjpeUBi
'' SIG '' JZZux8c3aoMhCI5B6t3ZVz8dd0mHKhYGXqY4aiISo1EZ
'' SIG '' g362MIIEozCCA4ugAwIBAgIQDs/0OMj+vzVuBNhqmBsa
'' SIG '' UDANBgkqhkiG9w0BAQUFADBeMQswCQYDVQQGEwJVUzEd
'' SIG '' MBsGA1UEChMUU3ltYW50ZWMgQ29ycG9yYXRpb24xMDAu
'' SIG '' BgNVBAMTJ1N5bWFudGVjIFRpbWUgU3RhbXBpbmcgU2Vy
'' SIG '' dmljZXMgQ0EgLSBHMjAeFw0xMjEwMTgwMDAwMDBaFw0y
'' SIG '' MDEyMjkyMzU5NTlaMGIxCzAJBgNVBAYTAlVTMR0wGwYD
'' SIG '' VQQKExRTeW1hbnRlYyBDb3Jwb3JhdGlvbjE0MDIGA1UE
'' SIG '' AxMrU3ltYW50ZWMgVGltZSBTdGFtcGluZyBTZXJ2aWNl
'' SIG '' cyBTaWduZXIgLSBHNDCCASIwDQYJKoZIhvcNAQEBBQAD
'' SIG '' ggEPADCCAQoCggEBAKJjCzlEuLsjp0RJuw7/ofBhClOT
'' SIG '' sJjbrSwPSsVu/4Y8U1UPFc4EPyv9qZaW2b5heQtbyUyG
'' SIG '' duXgQ0sile7CK0PBn9hotI5AT+6FOLkRxSPyZFjwFTJv
'' SIG '' TlehroikAtcqHs1L4d1j1ReJMluwXplaqJ0oUA4X7pbb
'' SIG '' YTtFUR3PElYLkkf8q672Zj1HrHBy55LnX80QucSDZJQZ
'' SIG '' vSWA4ejSIqXQugJ6oXeTW2XD7hd0vEGGKtwITIySjJEt
'' SIG '' nndEH2jWqHR32w5bMotWizO92WPISZ06xcXqMwvS8aMb
'' SIG '' 9Iu+2bNXizveBKd6IrIkri7HcMW+ToMmCPsLvalPmQjh
'' SIG '' EChyqs0CAwEAAaOCAVcwggFTMAwGA1UdEwEB/wQCMAAw
'' SIG '' FgYDVR0lAQH/BAwwCgYIKwYBBQUHAwgwDgYDVR0PAQH/
'' SIG '' BAQDAgeAMHMGCCsGAQUFBwEBBGcwZTAqBggrBgEFBQcw
'' SIG '' AYYeaHR0cDovL3RzLW9jc3Aud3Muc3ltYW50ZWMuY29t
'' SIG '' MDcGCCsGAQUFBzAChitodHRwOi8vdHMtYWlhLndzLnN5
'' SIG '' bWFudGVjLmNvbS90c3MtY2EtZzIuY2VyMDwGA1UdHwQ1
'' SIG '' MDMwMaAvoC2GK2h0dHA6Ly90cy1jcmwud3Muc3ltYW50
'' SIG '' ZWMuY29tL3Rzcy1jYS1nMi5jcmwwKAYDVR0RBCEwH6Qd
'' SIG '' MBsxGTAXBgNVBAMTEFRpbWVTdGFtcC0yMDQ4LTIwHQYD
'' SIG '' VR0OBBYEFEbGaaMOShQe1UzaUmMXP142vA3mMB8GA1Ud
'' SIG '' IwQYMBaAFF+a9W5czMx0mtTdfe8/2+xMgC7dMA0GCSqG
'' SIG '' SIb3DQEBBQUAA4IBAQB4O7SRKgBM8I9iMDd4o4QnB28Y
'' SIG '' st4l3KDUlAOqhk4ln5pAAxzdzuN5yyFoBtq2MrRtv/Qs
'' SIG '' JmMz5ElkbQ3mw2cO9wWkNWx8iRbG6bLfsundIMZxD82V
'' SIG '' dNy2XN69Nx9DeOZ4tc0oBCCjqvFLxIgpkQ6A0RH83Vx2
'' SIG '' bk9eDkVGQW4NsOo4mrE62glxEPwcebSAe6xp9P2ctgwW
'' SIG '' K/F/Wwk9m1viFsoTgW0ALjgNqCmPLOGy9FqpAa8VnCwv
'' SIG '' SRvbIrvD/niUUcOGsYKIXfA9tFGheTMrLnu53CAJE3Hr
'' SIG '' ahlbz+ilMFcsiUk/uc9/yb8+ImhjU5q9aXSsxR08f5Lg
'' SIG '' w7wc2AR1MIIFVjCCBD6gAwIBAgIQGRoyy3Wcl7jPrBGN
'' SIG '' 1RJ/STANBgkqhkiG9w0BAQsFADCByjELMAkGA1UEBhMC
'' SIG '' VVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMR8wHQYD
'' SIG '' VQQLExZWZXJpU2lnbiBUcnVzdCBOZXR3b3JrMTowOAYD
'' SIG '' VQQLEzEoYykgMjAwNiBWZXJpU2lnbiwgSW5jLiAtIEZv
'' SIG '' ciBhdXRob3JpemVkIHVzZSBvbmx5MUUwQwYDVQQDEzxW
'' SIG '' ZXJpU2lnbiBDbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENl
'' SIG '' cnRpZmljYXRpb24gQXV0aG9yaXR5IC0gRzUwHhcNMTQw
'' SIG '' MzA0MDAwMDAwWhcNMjQwMzAzMjM1OTU5WjCBkTELMAkG
'' SIG '' A1UEBhMCVVMxHTAbBgNVBAoTFFN5bWFudGVjIENvcnBv
'' SIG '' cmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBUcnVzdCBO
'' SIG '' ZXR3b3JrMUIwQAYDVQQDEzlTeW1hbnRlYyBDbGFzcyAz
'' SIG '' IEV4dGVuZGVkIFZhbGlkYXRpb24gQ29kZSBTaWduaW5n
'' SIG '' IENBIC0gRzIwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAw
'' SIG '' ggEKAoIBAQDQGALu7aKNCFhjDybX3SJ7iPbkx+w7Jhh4
'' SIG '' 08ekIFONg3ylP36lyCtH3w31ptnDHSWTYM983OoDLL54
'' SIG '' f1xIbacC2Un4oevrmmF8n8Am1twV2LgQfCC6XvQo9qjq
'' SIG '' p1x8xpyQkDQ8tiKs/roMOh7WXoS2W/CjgXB4io1GUnv8
'' SIG '' 20nzKRMRdE+NFrPC46AtxwMEnczDcuEODPsCjvEmF3tu
'' SIG '' rvi3M4umYUtF3/IlRMf3sJgjNtwoeQrom3KIqNjornt/
'' SIG '' CmRFpfBXkpp3BkUe65/oZvN6fZKBXwAtHrj2VhNaYg23
'' SIG '' R6GPcu+DXoLglJjhrKWthjfgp9O6sT5660Wo8cFEfeID
'' SIG '' AgMBAAGjggFtMIIBaTASBgNVHRMBAf8ECDAGAQH/AgEA
'' SIG '' MC8GA1UdHwQoMCYwJKAioCCGHmh0dHA6Ly9zLnN5bWNi
'' SIG '' LmNvbS9wY2EzLWc1LmNybDAWBgNVHSUBAf8EDDAKBggr
'' SIG '' BgEFBQcDAzAOBgNVHQ8BAf8EBAMCAQYwLgYIKwYBBQUH
'' SIG '' AQEEIjAgMB4GCCsGAQUFBzABhhJodHRwOi8vcy5zeW1j
'' SIG '' ZC5jb20wXwYDVR0gBFgwVjBUBgRVHSAAMEwwIwYIKwYB
'' SIG '' BQUHAgEWF2h0dHBzOi8vZC5zeW1jYi5jb20vY3BzMCUG
'' SIG '' CCsGAQUFBwICMBkaF2h0dHBzOi8vZC5zeW1jYi5jb20v
'' SIG '' cnBhMCkGA1UdEQQiMCCkHjAcMRowGAYDVQQDExFTeW1h
'' SIG '' bnRlY1BLSS0xLTYyOTAdBgNVHQ4EFgQUFmbeSjTjUKcR
'' SIG '' hgOxbKnGrM1ZbpswHwYDVR0jBBgwFoAUf9Nlp8Ld7Lvw
'' SIG '' MAnzQzn6Aq8zMTMwDQYJKoZIhvcNAQELBQADggEBAD9b
'' SIG '' GfP6E9V1OCpa7p9aoEypHcXMlO7eFf71EG6kG6Vkg1QY
'' SIG '' WMQLKKGFw0505f+JfP7V7Ty6cZ9WAiaPFiqI/rCjJyLO
'' SIG '' S+I4jgCmOoZfneU+qN5kSUF0QSH9B8iEF9odZTCCyyZP
'' SIG '' OdYEJ6SBsUtJwyOLfgIyGCe3qwvzGHK2pO5nBm84pliN
'' SIG '' 4PF+XaRgxqjlUF/g6Lrij5lYtrWgqHbxovEciEFyflKX
'' SIG '' mwo2mY1Q9wHrPOfwImrlNYxjNooasdlnZl+XGu+oIJ3w
'' SIG '' L7psztmUhQDxWPF9yXwitQddAsbmC7+rk5P/JxiOMzZ+
'' SIG '' VzTxw68EwYTxVrPoh4M2+NMKMdxuLG0wggXEMIIErKAD
'' SIG '' AgECAhAeObM6nEaakCI61S77g784MA0GCSqGSIb3DQEB
'' SIG '' CwUAMIGRMQswCQYDVQQGEwJVUzEdMBsGA1UEChMUU3lt
'' SIG '' YW50ZWMgQ29ycG9yYXRpb24xHzAdBgNVBAsTFlN5bWFu
'' SIG '' dGVjIFRydXN0IE5ldHdvcmsxQjBABgNVBAMTOVN5bWFu
'' SIG '' dGVjIENsYXNzIDMgRXh0ZW5kZWQgVmFsaWRhdGlvbiBD
'' SIG '' b2RlIFNpZ25pbmcgQ0EgLSBHMjAeFw0xNTExMDYwMDAw
'' SIG '' MDBaFw0xNzEwMjgyMzU5NTlaMIIBDjETMBEGCysGAQQB
'' SIG '' gjc8AgEDEwJVUzEZMBcGCysGAQQBgjc8AgECFAhEZWxh
'' SIG '' d2FyZTEdMBsGA1UEDxMUUHJpdmF0ZSBPcmdhbml6YXRp
'' SIG '' b24xEDAOBgNVBAUTBzI3NDgxMjkxCzAJBgNVBAYTAlVT
'' SIG '' MRMwEQYDVQQIDApDYWxpZm9ybmlhMREwDwYDVQQHDAhT
'' SIG '' YW4gSm9zZTEjMCEGA1UECgwaQWRvYmUgU3lzdGVtcyBJ
'' SIG '' bmNvcnBvcmF0ZWQxLDAqBgNVBAsMI0lsbHVzdHJhdG9y
'' SIG '' LCBJbkRlc2lnbiwgSW5Db3B5LCBNdXNlMSMwIQYDVQQD
'' SIG '' FBpBZG9iZSBTeXN0ZW1zIEluY29ycG9yYXRlZDCCASIw
'' SIG '' DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJpOMyAj
'' SIG '' 8r+7FuNs3MXed0OMajoJnoF4v8cV+9drUVII+pzb6yeV
'' SIG '' GdBTt8U03rk1a2V51gcTHAorQxs2plJIgafn/pqMzG7f
'' SIG '' 9FZui7WiMOuyif/0joytDGujeQd7xQ/23YYtZpQQ/ahz
'' SIG '' VI4Pzv44FVDGwHYfGxGaQ127Bqp5EhLX7zwFiGEPnP3V
'' SIG '' R4ZyQn2WQeA0a68KuhD6anNHize0XjSBFelrNhN4uYpk
'' SIG '' prXyGv8vKdq9a911iY/efPsRueUPYucYJCF/lBt3DaR4
'' SIG '' J/FeaSJeijyllNwAqu7XY7Jl9zB0duRLlRFpGJeCymhY
'' SIG '' 3wvU6039CHBnrYIXZ/ldAWUpz+MCAwEAAaOCAZYwggGS
'' SIG '' MC4GA1UdEQQnMCWgIwYIKwYBBQUHCAOgFzAVDBNVUy1E
'' SIG '' RUxBV0FSRS0yNzQ4MTI5MAkGA1UdEwQCMAAwKwYDVR0f
'' SIG '' BCQwIjAgoB6gHIYaaHR0cDovL3N3LnN5bWNiLmNvbS9z
'' SIG '' dy5jcmwwFgYDVR0lAQH/BAwwCgYIKwYBBQUHAwMwDgYD
'' SIG '' VR0PAQH/BAQDAgeAMGYGA1UdIARfMF0wWwYLYIZIAYb4
'' SIG '' RQEHFwYwTDAjBggrBgEFBQcCARYXaHR0cHM6Ly9kLnN5
'' SIG '' bWNiLmNvbS9jcHMwJQYIKwYBBQUHAgIwGQwXaHR0cHM6
'' SIG '' Ly9kLnN5bWNiLmNvbS9ycGEwHQYDVR0OBBYEFPsxU7iZ
'' SIG '' MQ82sRMZZ9wcUZpCtgBaMFgGCCsGAQUFBwEBBEwwSjAf
'' SIG '' BggrBgEFBQcwAYYTaHR0cDovL3N3LnN5bWNkLmNvbTAn
'' SIG '' BggrBgEFBQcwAoYbaHR0cDovL3N3MS5zeW1jYi5jb20v
'' SIG '' c3cuY3J0MB8GA1UdIwQYMBaAFBZm3ko041CnEYYDsWyp
'' SIG '' xqzNWW6bMA0GCSqGSIb3DQEBCwUAA4IBAQBQEAjwXAas
'' SIG '' FygBRU/4fmAgJdTZDZFT/Gri5Vi28b6iHzDnTKcr3QTJ
'' SIG '' 33Ql9LbIi2CjtnD1n0zyvIdjXDXFLcbeMoQQ9L5XuiRw
'' SIG '' kwUPpRrLYsNPQ8G3n7N/me223Sw4noAy0ErrUNZd4Bew
'' SIG '' mTc3hn/95O1LC9QuGNFv/l+RyyFXBe3iJvHOpMBwIkMa
'' SIG '' OXB5/2FbFLqqELV4zWE2GXHhxfgxTgHHww1pJNBdPpxR
'' SIG '' qIjQxmgkL24azZZyxxtRWI6mpgCu+/4ZeXzwKSMycBYc
'' SIG '' gVG9c5TUSh+s1a4HPrrBJ1lPJQ+8+v3rc6ytjZXAC/g8
'' SIG '' GhhIrxvatjLMNWzrFNG7iEciMYIEhjCCBIICAQEwgaYw
'' SIG '' gZExCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
'' SIG '' YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMg
'' SIG '' VHJ1c3QgTmV0d29yazFCMEAGA1UEAxM5U3ltYW50ZWMg
'' SIG '' Q2xhc3MgMyBFeHRlbmRlZCBWYWxpZGF0aW9uIENvZGUg
'' SIG '' U2lnbmluZyBDQSAtIEcyAhAeObM6nEaakCI61S77g784
'' SIG '' MAkGBSsOAwIaBQCggaYwGQYJKoZIhvcNAQkDMQwGCisG
'' SIG '' AQQBgjcCAQQwHAYKKwYBBAGCNwIBCzEOMAwGCisGAQQB
'' SIG '' gjcCARUwIwYJKoZIhvcNAQkEMRYEFADIcnJG+3WFzLbz
'' SIG '' SW7IqpmZ6r7QMEYGCisGAQQBgjcCAQwxODA2oDSAMgBB
'' SIG '' AGQAbwBiAGUAIABJAGwAbAB1AHMAdAByAGEAdABvAHIA
'' SIG '' IABDAEMAIAAyADAAMQA1MA0GCSqGSIb3DQEBAQUABIIB
'' SIG '' ACShromjxQhbx9v9s4LOnXgUc0PWyHZNcuVUX5s0K178
'' SIG '' KoOY66PxwrtJkY1AoRZ7YGYQuHrZi0CegFp1af05dllM
'' SIG '' 9RlidWFxP1apZJngq3jbjCSa479KzQSKxF/fees40YsC
'' SIG '' 3vPTBMWneIt/DWYveTLEwIqwu3U3V5zwQRg3n/PSnVCK
'' SIG '' cGUtUfgCBY5Vv+BRnZlM+6CptE7RyK+iim7b8Umy5TLw
'' SIG '' tzKN1byPnILItOQD3yXCR/gQojjNaZZl7ikHcY3p0Xo/
'' SIG '' Ssza7PKNGUWCaM5JZmAQGSje0Xe4sRhpb8kR+/ZQk8od
'' SIG '' pvQY+3qg7qpqcUUMMQwwWCjhlfl7v3uW7CGhggILMIIC
'' SIG '' BwYJKoZIhvcNAQkGMYIB+DCCAfQCAQEwcjBeMQswCQYD
'' SIG '' VQQGEwJVUzEdMBsGA1UEChMUU3ltYW50ZWMgQ29ycG9y
'' SIG '' YXRpb24xMDAuBgNVBAMTJ1N5bWFudGVjIFRpbWUgU3Rh
'' SIG '' bXBpbmcgU2VydmljZXMgQ0EgLSBHMgIQDs/0OMj+vzVu
'' SIG '' BNhqmBsaUDAJBgUrDgMCGgUAoF0wGAYJKoZIhvcNAQkD
'' SIG '' MQsGCSqGSIb3DQEHATAcBgkqhkiG9w0BCQUxDxcNMTYw
'' SIG '' MTE0MjMxNDUyWjAjBgkqhkiG9w0BCQQxFgQUNFMkZrNX
'' SIG '' JTJ2MCNrzxlES0pTU7cwDQYJKoZIhvcNAQEBBQAEggEA
'' SIG '' PfBwIRT+K7bpgUdW4V+GmyTRc+7EfI7wqn5qMrMrglPj
'' SIG '' w6Lgp6ic4fnxA8UHt8xppn5hQovNk1RMBmyXyqQ+C1jM
'' SIG '' rKEppUefucJSpVKhLxu0tOek4FfK+db21YkX7ouBgHUQ
'' SIG '' rDAOAtK1baoZlnxprjw/xwS47FteRkMBAimJwROBJRgh
'' SIG '' odHreCdXV7l4xeKqJkSJ9WTWuCUaLcBFzw0WuMtBbsGO
'' SIG '' 8SQSXfAtlCimq8QjA8jl0TcZONTHrmx06PYyoI6z/uin
'' SIG '' LkGTU8D2apHalwUT43qHFVuwLr8tUd2kcyENh5TIUsp/
'' SIG '' d2vWYh76g/xcidNc3G/qqjeLOcI4uAls5Q==
'' SIG '' End signature block
